<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<ItineraryDetailsViewModel>" %>
<% Ajax.RegisterClientScriptInclude(Url.Content("~/Content/Scripts/jquery-1.3.2.min.js"), "http://ajax.Microsoft.com/ajax/jQuery/jquery-1.3.2.min.js"); %>
<% Ajax.RegisterClientScriptInclude(Url.Content("~/Content/Scripts/MicrosoftAjax.js"), "http://ajax.Microsoft.com/ajax/beta/0909/MicrosoftAjax.js"); %>
<% Ajax.RegisterClientScriptInclude(Url.Content("~/Content/Scripts/MicrosoftAjaxTemplates.js"), "http://ajax.Microsoft.com/ajax/beta/0909/MicrosoftAjaxTemplates.js"); %>
<% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/jquery-ui-1.7.2.custom.js"), "pmn"); %>
<% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/ajax.common.js"), "pmn"); %>
<% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/ajax.search.itineraries.js"), "pmn"); %>

<hr />
<div id="itinerary" class="panel">
    <div class="innerPanel">
        <h2><span>
        <% if(String.IsNullOrEmpty(Model.Name)) { %>
            Your current itinerary
        <% } else { %>
            Itinerary: <%:Model.Name%>
        <% } %>
        </span></h2>
        
        <div class="static" id="itineraryStatic">
            <div class="subheader">
                Total estimated time: <%: TimeHelper.GetFriendlyTime(Model.EstimatedMinutes)%>
            </div>
            <div class="items">
            <% if (Model.ActivitiesCount == 0) %>
            <% { %>
                <p>Your itinerary is currently empty.</p>
                <p>Perform a search and then select activities to build an itinerary...</p>
            <% } else { %>
                <ul class="activities">
                <% var i = 0; %>
                <% foreach (var item in Model.Activities) %>
                <% { %>
                    <li>
                        <h3><a href="<%=Html.AttributeEncode(item.DetailsLink)%>"><%:item.Entity.Name%></a></h3>
                        <p><%:item.Entity.Street%></p>
                        <p><%:item.Entity.City%>, <%:item.Entity.State%> <%:item.Entity.Zip%> | Phone: <%:item.Entity.PhoneNumber%></p>
                        <% using (Html.BeginForm<ItinerariesController>(c => c.SetEstimatedTime(item.Entity.Id, 0), FormMethod.Post, new { @class = "inline" }))
                           { %>
                            Time: <%=Html.TextBox("estimatedMinutes", item.EstimatedMinutes, new { @class = "estimatedMinutes", maxlength = 3, size = 2 }) %>min
                            <input type="submit" value="Set Time" />
                            <%=Html.AntiForgeryToken() %>
                        <% } %>
                        <p class="options">
                            <span class="sep">|</span>
                            <a href="<%=Html.AttributeEncode(item.RemoveFromItineraryLink)%>" class="btn remove">Remove</a>
                            <% if(i > 0) { %>
                                <span class="sep">|</span>
                                <a href="<%=Html.AttributeEncode(item.MoveUpInItineraryLink) %>" class="btn moveUp">Move Up</a>
                            <% } %>
                            <% if(i < Model.ActivitiesCount - 1) { %>
                                <span class="sep">|</span>
                                <a href="<%=Html.AttributeEncode(item.MoveDownInItineraryLink) %>" class="btn moveDown">Move Down</a>
                            <% } %>
                            <% if(Ajax.JavaScriptEnabled()) { %><span class="sep">|</span><span style="display:none" class="handler">Drag to Reorder</span><% } %>
                        </p>
                    </li>
                    <% i++; %>
                <% } %>
                </ul>
            <% } %>
            </div>
        </div>
        
        <% if(Ajax.JavaScriptEnabled()) { %>
        <div id="itineraryDynamic" style="display:none;" class="off">
            <div class="subheader">
                Total estimated time: <span id="totalEstimatedTime">0 min</span>
            </div>
            <div class="items loading">
            
                <div id="itineraryError" class="sys-template ajaxError off">
                    <h3>Ooops!<br />An error occurred.</h3>
                    <p>Want to <a class="retry" sys:href="{{RetryUrl}}">try again?</a></p>
                    <p class="details" sys:if="$dataItem.Details!=''">{{Details}}</p>
                </div>
            
                <div class="empty" style="display:none">
                    <p>Your itinerary is currently empty.</p>
                    <p>Perform a search and then select activities to build an itinerary...</p>
                </div>
                <ul id="itineraryDynamicList" class="sys-template activities" style="display:none">
                    <li class="ui-state-default">
                        <span class="off id">{{Entity.Id}}</span>
                        <h3><a sys:href="{{DetailsLink}}">{{Entity.Name}}</a></h3>
                        <p>{{Entity.Street}}</p>
                        <p>{{Entity.City}}, {{Entity.State}} {{Entity.Zip}} | Phone: {{Entity.PhoneNumber}}</p>
                        <form class="inline estimatedMinutes" method="post" sys:action="{{SetEstimatedTimeLink}}">
                            Time: <input name="estimatedMinutes" type="text" sys:value="{{EstimatedMinutes}}" class="estimatedMinutes" maxlength="3" size="2" />min
                            <input type="submit" value="Set Time" />
                            <%=Html.AntiForgeryToken() %>
                        </form>
                        <p class="options">
                            <span class="sep">|</span>
                            <a sys:href="{{RemoveFromItineraryLink}}" class="btn remove">Remove</a>
                            <span class="sep">|</span>
                            <span style="display:none" class="handler" sys:href="{{MoveDownInItineraryLink}}">Drag to Reorder</span>
                        </p>
                    </li>
                </ul>
            </div>
         </div>
         
        <script type="text/javascript">document.getElementById("itineraryStatic").style.display = 'none' </script>
        <script type="text/javascript">document.getElementById("itineraryDynamic").style.display = 'block' </script>
        <% } %>

        
        <div class="toolbox">
            <%
                foreach (var action in Model.AddinBoxes)
                {
                    Html.RenderAddinRoute(action);
                }
            %>
            <% Html.RenderPartial("SaveToolbox");  %>
            <div class="pager" style="display: <%= Model.ActivitiesCount > 0 ? "block" : "none" %>">
                <ul>
                    <li>
                        <% using(Html.BeginForm<ItinerariesController>(c => c.New(), FormMethod.Post, new { @class = "new", onsubmit = "return confirm('Any unsaved changes to the current itinerary will be lost.\\nAre you sure you want to continue?')" })) { %>
                            <%=Html.AntiForgeryToken()%>
                            <input type="submit" class="new" value="New" />
                        <% } %>
                    </li>
                    <li><%= Html.ActionLink<ItinerariesController>(c => c.Save(), "Save", new { @class = "save", id = "saveItineraryLink", rel = "nofollow" })%></li>
                    <% foreach(var link in Model.AddinLinks) { %>
                        <li><%=Html.RouteLink(link.LinkText, link.RouteLink, link.Attributes)%></li>
                    <% } %>
                </ul>
            </div>
        </div>
    </div>
</div>